
#include "EEPROM.h"
#include <plib.h>


const unsigned int eedata_addr[NUM_DATA_EE_PAGES][NUMBER_OF_INSTRUCTIONS_IN_PAGE] __attribute__ ((aligned(4096)))={{0}};
unsigned int* EEPROM_CurPos;

static unsigned int EEShuffleForward(unsigned int page)  {
    unsigned int retCode;
    unsigned int seen_addr_bitmap[(EE_MAX_ADDR+32)/32] = { 0 };
    int cur_page = page, i;

    if( ++cur_page == NUM_DATA_EE_PAGES )
        cur_page = 0;
    while( cur_page != page && eedata_addr[cur_page][0] != 0xFFFFFFFF ) {
        for( i = 0; i < NUMBER_OF_INSTRUCTIONS_IN_PAGE; ++i ) {
            unsigned int addr = eedata_addr[cur_page][i]>>24;
            if( addr <= EE_MAX_ADDR )
                seen_addr_bitmap[addr/32] |= 1<<(addr&31);
        }
        if( ++cur_page == NUM_DATA_EE_PAGES )
            cur_page = 0;
    }

    for( i = NUMBER_OF_INSTRUCTIONS_IN_PAGE-1; i >= 0; --i ) {
        if( eedata_addr[page][i] != 0xFFFFFFFF ) {
            unsigned int addr = eedata_addr[page][i]>>24;
            if( addr <= EE_MAX_ADDR && !(seen_addr_bitmap[addr/32]&(1<<(addr&31))) ) {
                retCode = DataEEWrite(eedata_addr[page][i]&0xFFFFFF, addr);
                if( retCode )
                    return retCode;
                seen_addr_bitmap[addr/32] |= 1<<(addr&31);
            }
        }
    }

    return 0;
}

unsigned int DataEEInit(void) {
    unsigned int retCode;
    int i, cur_page, start_page = -1, required_blank_pages;

    for( i = 0; i < NUM_DATA_EE_PAGES; ++i ) {
        if( eedata_addr[i][0] == 0xFFFFFFFF ) {
            start_page = i;
            break;
        }
    }
    if( start_page == -1 ) {
        for( i = 0; i < NUM_DATA_EE_PAGES; ++i ) {
            retCode = NVMErasePage((void*)eedata_addr[i]);
            if( retCode != 0 )
                return retCode;
        }
        EEPROM_CurPos = (unsigned int*)eedata_addr;
        return 0;
    }

    cur_page = start_page;
    do {
        if( --cur_page < 0 )
            cur_page = NUM_DATA_EE_PAGES-1;
        for( i = NUMBER_OF_INSTRUCTIONS_IN_PAGE-1; i >= 0; --i ) {
            if( eedata_addr[cur_page][i] != 0xFFFFFFFF ) {
                EEPROM_CurPos = (unsigned int*)&eedata_addr[cur_page][i];
                if( (char*)++EEPROM_CurPos == ((char*)eedata_addr)+sizeof(eedata_addr) )
                    EEPROM_CurPos = (unsigned int*)eedata_addr;
                break;
            }
        }
    } while( cur_page != start_page );

    if( cur_page == start_page )
        return 6;

    required_blank_pages = NUM_EE_PAGES_KEEP_FREE;
    start_page = cur_page;
    do {
        if( ++cur_page == NUM_DATA_EE_PAGES )
            cur_page = 0;
        if( eedata_addr[cur_page][0] != 0xFFFFFFFF ) {
            retCode = EEShuffleForward(cur_page);
            if( retCode == 0 )
                retCode = NVMErasePage((void*)eedata_addr[cur_page]);
            if( retCode != 0 )
                return retCode;
        }
    } while( --required_blank_pages && cur_page != start_page );

    return 0;
}

unsigned int DataEEReadArray(unsigned int *data, unsigned int addr, unsigned int size) {
    int i, cur_page, start_page = -1;

    for( i = 0; i < NUM_DATA_EE_PAGES; ++i ) {
        if( eedata_addr[i][0] == 0xFFFFFFFF ) {
            start_page = i;
            break;
        }
    }
    if( start_page == -1 )
        return 1;
    cur_page = start_page;
    do {
        if( ++cur_page == NUM_DATA_EE_PAGES )
            cur_page = 0;
        if( eedata_addr[cur_page][0] != 0xFFFFFFFF ) {
            for( i = 0; i < NUMBER_OF_INSTRUCTIONS_IN_PAGE; ++i ) {
                if( eedata_addr[cur_page][i] != 0xFFFFFFFF ) {
                    unsigned long read_addr = eedata_addr[cur_page][i]>>24;
                    if( read_addr >= addr && read_addr < addr+size )
                        data[read_addr-addr] = eedata_addr[cur_page][i]&0xFFFFFF;
                }
            }
        }
    } while( cur_page != start_page );

    return 0;
}

unsigned int DataEEWrite(unsigned int data, unsigned int addr) {
    unsigned int retCode;

    retCode = NVMWriteWord((void*)EEPROM_CurPos, (addr<<24)|(data&0xFFFFFF));
    if( !retCode ) {
        if( (char*)++EEPROM_CurPos == ((char*)eedata_addr)+sizeof(eedata_addr) )
            EEPROM_CurPos = (unsigned int*)eedata_addr;
        if( *EEPROM_CurPos != 0xFFFFFFFF )
            retCode = NVMErasePage((void*)EEPROM_CurPos);
    }
    return retCode;
}
